/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.ArrayList;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XWriter;

public class Depend {
    private final String name;
    private final Constraint[] constraints;

    public static Depend parse(String string) {
        try {
            return new Parser(string).parse();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid Depend: '" + string + '\'');
        }
    }

    public static Depend makeChecksum(String string, int n) {
        Constraint constraint = new Constraint();
        constraint.checksum = n;
        return new Depend(string, new Constraint[]{constraint});
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Depend) {
            return object.toString().equals(this.toString());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name).append(' ');
        int n = 0;
        while (n < this.constraints.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            Constraint constraint = this.constraints[n];
            if (constraint.version == null) {
                stringBuffer.append("0x").append(Integer.toHexString(constraint.checksum));
            } else {
                stringBuffer.append(constraint.version);
                if (constraint.isPlus) {
                    stringBuffer.append('+');
                }
                if (constraint.isExact) {
                    stringBuffer.append('=');
                }
                if (constraint.endVersion != null) {
                    stringBuffer.append('-').append(constraint.endVersion);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int size() {
        return this.constraints.length;
    }

    public Version version(int n) {
        return this.constraints[n].version;
    }

    public boolean isPlus(int n) {
        return this.constraints[n].isPlus;
    }

    public boolean isExact(int n) {
        return this.constraints[n].isExact;
    }

    public boolean isRange(int n) {
        boolean bl = false;
        if (this.constraints[n].endVersion != null) {
            bl = true;
        }
        return bl;
    }

    public Version endVersion(int n) {
        return this.constraints[n].endVersion;
    }

    public int checksum(int n) {
        return this.constraints[n].checksum;
    }

    public boolean match(Version version) {
        return this.match(version, -1);
    }

    public boolean match(int n) {
        return this.match(null, n);
    }

    public boolean match(Version version, int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = 0;
        while (n2 < this.constraints.length) {
            Constraint constraint = this.constraints[n2];
            if (constraint.checksum != -1) {
                boolean bl5 = false;
                if (n != -1) {
                    bl5 = true;
                }
                bl2 = bl5;
            } else {
                boolean bl6 = false;
                if (version != null) {
                    bl6 = bl = true;
                }
            }
            if (n != -1) {
                bl4 |= this.matchChecksum(constraint, n);
            }
            if (version != null) {
                bl3 |= this.matchVersion(constraint, version);
            }
            ++n2;
        }
        if (bl) {
            if (bl2) {
                return bl3 & bl4;
            }
            return bl3;
        }
        return bl4;
    }

    private final boolean matchChecksum(Constraint constraint, int n) {
        boolean bl = false;
        if (constraint.checksum == n) {
            bl = true;
        }
        return bl;
    }

    private final boolean matchVersion(Constraint constraint, Version version) {
        if (constraint.version == null) {
            return false;
        }
        if (constraint.isPlus) {
            boolean bl = false;
            if (constraint.version.compareTo(version) <= 0) {
                bl = true;
            }
            return bl;
        }
        if (constraint.isExact) {
            boolean bl = false;
            if (constraint.version.compareTo(version) == 0) {
                bl = true;
            }
            return bl;
        }
        if (constraint.endVersion != null) {
            boolean bl = false;
            if (constraint.version.compareTo(version) <= 0 && (constraint.endVersion.compareTo(version) >= 0 || Depend.doMatch(constraint.endVersion, version))) {
                bl = true;
            }
            return bl;
        }
        return Depend.doMatch(constraint.version, version);
    }

    private static final boolean doMatch(Version version, Version version2) {
        if (version.size() > version2.size()) {
            return false;
        }
        int n = 0;
        while (n < version.size()) {
            if (version.get(n) != version2.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void encodeXml(XWriter xWriter) {
        xWriter.w("  <depend ").attr("on", this.toString()).w("/>\n");
    }

    public static Depend decodeXml(XElem xElem) {
        return Depend.parse(xElem.get("on"));
    }

    private Depend(String string, Constraint[] constraintArray) {
        this.name = string;
        this.constraints = constraintArray;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Parser {
        int cur;
        int pos;
        int len;
        String str;
        String name;
        ArrayList constraints;

        Depend parse() {
            this.name = this.name();
            this.constraints.add(this.constraint());
            while (this.cur == 44) {
                this.consume();
                this.consumeSpaces();
                this.constraints.add(this.constraint());
            }
            if (this.pos <= this.len) {
                throw new RuntimeException();
            }
            return new Depend(this.name, this.constraints.toArray(new Constraint[this.constraints.size()]));
        }

        private final String name() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.cur != 32) {
                if (this.cur < 0) {
                    throw new RuntimeException();
                }
                stringBuffer.append((char)this.cur);
                this.consume();
            }
            this.consumeSpaces();
            if (stringBuffer.length() == 0) {
                throw new RuntimeException();
            }
            return stringBuffer.toString();
        }

        private final Constraint constraint() {
            Constraint constraint = new Constraint();
            if (this.cur == 48 && this.peek() == 120) {
                constraint.checksum = this.checksum();
                return constraint;
            }
            constraint.version = this.version();
            this.consumeSpaces();
            if (this.cur == 43) {
                constraint.isPlus = true;
                this.consume();
                this.consumeSpaces();
            } else if (this.cur == 61) {
                constraint.isExact = true;
                this.consume();
                this.consumeSpaces();
            } else if (this.cur == 45) {
                this.consume();
                this.consumeSpaces();
                constraint.endVersion = this.version();
                this.consumeSpaces();
            }
            return constraint;
        }

        private final Version version() {
            int[] nArray = new int[8];
            int n = this.consumeDigit();
            int n2 = 0;
            while (true) {
                if (48 <= this.cur && this.cur <= 57) {
                    n = n * 10 + this.consumeDigit();
                    continue;
                }
                nArray[n2++] = n;
                n = 0;
                if (this.cur != 46) break;
                this.consume();
            }
            return new Version(nArray, n2);
        }

        private final int checksum() {
            int n;
            this.consume();
            this.consume();
            int n2 = 0;
            while ((n = this.consumeHexDigit()) >= 0) {
                n2 = n2 << 4 | n;
            }
            return n2;
        }

        private final int consumeDigit() {
            if (48 <= this.cur && this.cur <= 57) {
                int n = this.cur - 48;
                this.consume();
                return n;
            }
            throw new RuntimeException();
        }

        private final int consumeHexDigit() {
            if (48 <= this.cur && this.cur <= 57) {
                int n = this.cur - 48;
                this.consume();
                return n;
            }
            if (97 <= this.cur && this.cur <= 102) {
                int n = this.cur - 97 + 10;
                this.consume();
                return n;
            }
            if (65 <= this.cur && this.cur <= 70) {
                int n = this.cur - 65 + 10;
                this.consume();
                return n;
            }
            return -1;
        }

        private final void consumeSpaces() {
            while (this.cur == 32) {
                this.consume();
            }
        }

        private final int peek() {
            if (this.pos >= this.len) {
                return -1;
            }
            return this.str.charAt(this.pos);
        }

        private final void consume() {
            if (this.pos < this.len) {
                this.cur = this.str.charAt(this.pos++);
            } else {
                this.cur = -1;
                this.pos = this.len + 1;
            }
        }

        private final /* synthetic */ void this() {
            this.constraints = new ArrayList(4);
        }

        Parser(String string) {
            this.this();
            this.str = string;
            this.len = string.length();
            this.consume();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Constraint {
        Version version;
        boolean isPlus;
        boolean isExact;
        Version endVersion;
        int checksum;

        private final /* synthetic */ void this() {
            this.checksum = -1;
        }

        Constraint() {
            this.this();
        }
    }
}

